#include "GetPoint.js"

function DoText()
{
	var ui = moi.ui;

	var pointpicker = ui.createPointPicker();
	if ( !GetPoint( pointpicker ) )
		return;
		
	var frame = pointpicker.orientedptframe;


	var factory = moi.command.createFactory( 'text' );
	ui.commandUI.PopulateFonts( factory );
	
	ui.beginUIUpdate();
	ui.hideUI( 'BasePointPrompt' );
	ui.hideUI( 'CancelContainer' );
	ui.showUI( 'DoneCancelContainer' );
	ui.showUI( 'TextOptionsPrompt' );
	ui.showUI( 'TextOptions' );
	ui.endUIUpdate();
	
	factory.disableUpdate( true );

	factory.setInput( 0, frame );
	ui.bindUIToInput( 'text', 'value', factory.getInput(1) );
	ui.bindUIToInput( 'font', 'value', factory.getInput(2) );
	ui.bindUIToInput( 'bold', 'value', factory.getInput(3) );
	ui.bindUIToInput( 'italic', 'value', factory.getInput(4) );
	ui.bindUIToInput( 'type', 'value', factory.getInput(5) );
	ui.bindUIToInput( 'height', 'value', factory.getInput(6) );
	ui.bindUIToInput( 'extrusion', 'value', factory.getInput(7) );
	factory.setInput( 8, true ); // Preview mode.
	ui.bindUIToInput( 'font_style', 'value', factory.getInput(9) );
	ui.bindUIToInput( 'align', 'value', factory.getInput(10) );
	
	factory.disableUpdate( false );
	factory.update();

	var commandDialog = ui.commandDialog;
	while ( 1 )
	{
		if ( !commandDialog.waitForEvent() )
			return false;
			
		if ( commandDialog.event == 'done' || commandDialog.event == 'text_enter' )
			break;
	}
	
	factory.setInput( 8, false ); // Disable preview mode.
	
	factory.update();
	factory.commit();
}

DoText();
